#!/bin/sh

test_description="Do not fail if two always-ed targets run simultaneously"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

cat >all.do <<EOF
redo-ifchange version.h
echo ok
EOF
cat >version.h.do <<EOF
redo-ifchange date version version.h.in
VERSION=\$(cat version)
DATE=\$(cat date)
cat "\$2".in |
    sed -e "s/%%VERSION%%/\${VERSION}/g" \
        -e "s/%%DATE%%/\${DATE}/g" \
       >"\$3"
redo-stamp <"\$3"
EOF
cat >version.do <<EOF
echo some-vcs-version >"\$3"
redo-always
redo-stamp <"\$3"
EOF
cat >date.do <<EOF
date +'%Y%m%d_%H%M%S' >"\$3"
redo-always
redo-stamp <"\$3"
EOF
cat >version.h.in <<EOF
#define PRJ_VERSION "%%VERSION%%"
#define PRJ_BLDDATE "%%DATE%%"
EOF

test_expect_success "first run is successful" redo
sleep 1
test_expect_success "second run is successful" redo

test_done
