#!/bin/sh

test_description="Proper relative to DirPrefix ifcreate paths"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

mkdir -p a/b/c/d a/e
echo whatever >a/b/dep
cat >a/b/c/default.do <<EOF
echo called \$1
redo-ifcreate ../../e/dep
redo-ifchange ../dep
EOF
redo-ifchange a/b/c/d/file
stat1=`stat a/b/c/d/file`
sleep 1 # stat does not output fractions of seconds
redo-ifchange a/b/c/d/file
stat2=`stat a/b/c/d/file`

test_expect_success "file stays same" '[ "$stat1" = "$stat2" ]'

touch a/e/dep
redo-ifchange a/b/c/d/file
stat3=`stat a/b/c/d/file`

test_expect_success "ifcreate target works" '[ "$stat1" != "$stat3" ]'

test_done
