#!/bin/sh

test_description="Check failing if \$1 already exists"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

echo echo ok >foo.do
touch foo
test_expect_success "does not fail" "redo foo 2>out"
test_expect_success "message" 'grep -q "already existing" out'

export REDO_STOP_IF_MODIFIED=1
test_expect_success "must fail" 'redo foo 2>out ; [ $? = 1 ]'
unset REDO_STOP_IF_MODIFIED
test_expect_success "message" 'grep -q "already existing" out'

rm foo
test_expect_success "ok" "redo foo"

echo overwrite >foo
test_expect_success "externally modified" "redo foo 2>out"
test_expect_success "message" 'grep -q "externally modified" out'

test_done
